<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Operations extends Model 
{

    protected $table = 'operation_jobs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tipo', 'almacen', 'mercancia', 'transfer_from', 'transfer_to', 'complete', 'notes');
    protected $visible = array('tipo', 'almacen', 'mercancia', 'transfer_from', 'transfer_to', 'complete', 'notes');

    public function operationType()
    {
        return $this->belongsTo('Types');
    }

}